#ifndef UART_SYSTEM_H
#define UART_SYSTEM_H
// <<< Use Configuration Wizard in Context Menu >>>
// <e> Uart_Debug Enable/Disable
// </e>
#define Uart_Debug 0
#if (Uart_Debug == 1)
enum TXStatus{TX_SEND, TX_FINISH};
enum RXStatus{RX_INT, RX_HANDLE, RX_FINISH};

extern xdata unsigned short UartCount;
extern xdata unsigned char UartFlag;

extern xdata signed short Debug_A;
extern xdata signed short Debug_B;
extern xdata signed short Debug_C;
extern xdata signed short Debug_D;
extern xdata signed short Debug_E;
extern xdata signed short Debug_F;

extern xdata unsigned char TxFinish;
extern xdata unsigned char RxState;
extern xdata unsigned char Debug_TxCounter;
extern xdata unsigned char Debug_RxCounter;
extern xdata unsigned char Debug_PreRxCounter;
extern xdata unsigned char Debug_TxBuffer[20];
extern xdata unsigned char Debug_RxBuffer[20];
extern xdata unsigned char Debug_TxDataLen;

extern void Uart_Definition(void);
extern void Uart_Package_Build(void);
extern void Uart_ReadPackage_Build(void);
extern void Uart_Read_Handle(void);
extern void Uart_Send_Buffer(void);
extern void Uart_Read_Buffer(void);
extern void Uart_CheckSum_Fun(void);
#endif
// <<< end of configuration section >>>
#endif